﻿<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="System.Linq" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Page Language="c#" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Sprzedaż</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
</head>

<script runat="server">

    ParametryWydrukuDokumentu parametry;
    [Context]
    public ParametryWydrukuDokumentu Parametry {
        get { return parametry; }
        set { parametry = value; }
    }

    private class PozycjaWgCenyŚredniej : PozycjaWgCeny {
        private DoubleCy cenaNettoPoRabacie;
        private DoubleCy cenaBruttoPoRabacie;
        RodzajKorektyPozycji rodzajKorekty;
        public PozycjaWgCenyŚredniej(PozycjaDokHandlowego poz, int lp) : base(poz, lp) {
            this.cenaNettoPoRabacie = poz.CenaNettoPoRabacie;
            this.cenaBruttoPoRabacie = poz.CenaBruttoPoRabacie;
            if (poz.RodzajKorekty != RodzajKorektyPozycji.Brak)
                rodzajKorekty = poz.RodzajKorekty;
        }
        public void Dodaj(PozycjaDokHandlowego p) {
            base.Dodaj(p);
            if (!base.Ilosc.IsZero) {
                this.cenaNettoPoRabacie = new DoubleCy((double)base.WartoscCy.Value / base.Ilosc.Value, this.cenaNettoPoRabacie.Symbol);
                this.cenaNettoPoRabacie = this.cenaNettoPoRabacie.Round(2);
                this.cenaBruttoPoRabacie = new DoubleCy((double)(base.WartoscCy.Value + base.Stawka.VatOdNetto(base.WartoscCy.Value)) / base.Ilosc.Value, this.cenaBruttoPoRabacie.Symbol);
                this.cenaBruttoPoRabacie = this.cenaBruttoPoRabacie.Round(2);
            }
            if (p.RodzajKorekty != RodzajKorektyPozycji.Brak)
                rodzajKorekty = p.RodzajKorekty;
        }
        public override DoubleCy CenaNettoPoRabacie {
            get { return this.cenaNettoPoRabacie; }
        }
        public override DoubleCy CenaBruttoPoRabacie {
            get { return this.cenaBruttoPoRabacie; }
        }
        public new RodzajKorektyPozycji RodzajKorekty {
            get { return rodzajKorekty; }
        }
    }

    private IEnumerable PozycjeRazemWgTowaruICenyZKorektami(DokumentHandlowy dokument) {
        Hashtable ht = new Hashtable();
        Hashtable htK = new Hashtable();
        ArrayList arr = new ArrayList();
        ArrayList arrK = new ArrayList();
        int lp = 0;
        DokumentHandlowy korygowany = dokument.DokumentKorygowany;
        bool wszystkoPrzed = !dokument.Module.Config.Wydruki.TylkoRóżnicePrzedKorektą;
        bool wszystko = korygowany == null
            || !dokument.Module.Config.Wydruki.TylkoRóżniceNaKorekcie;
            foreach (PozycjaDokHandlowego poz in dokument.Pozycje) {
                
                if(poz.PozycjaKorygowana != null) {
                PozycjaWgCeny.Klucz klucz = new PozycjaWgCeny.Klucz(poz.PozycjaKorygowana);

                PozycjaWgCenyŚredniej p = (PozycjaWgCenyŚredniej)ht[klucz];
                PozycjaWgCenyŚredniej pK = (PozycjaWgCenyŚredniej)htK[klucz];
                if (p == null || pK == null) {
                    lp++;
                    if (wszystko || poz.RodzajKorekty != RodzajKorektyPozycji.Brak)
                        ht[klucz] = p = new PozycjaWgCenyŚredniej(poz, lp);
                    if (wszystkoPrzed || poz.RodzajKorekty != RodzajKorektyPozycji.Brak)
                        htK[klucz] = pK = new PozycjaWgCenyŚredniej(poz.PozycjaKorygowana, lp);
                }
                else {
                    p.Dodaj(poz);
                    pK.Dodaj(poz.PozycjaKorygowana);
                }
            }
            else {
                if (!wszystko && poz.RodzajKorekty == RodzajKorektyPozycji.Brak) continue;
                PozycjaWgCeny.Klucz klucz = new PozycjaWgCeny.Klucz(poz);
                PozycjaWgCeny p = (PozycjaWgCeny)ht[klucz];
                if (p == null) {
                    ht[klucz] = p = new PozycjaWgCeny(poz, ++lp);
                }
                else {
                    p.Dodaj(poz);
                }
            }
        }

        arrK.AddRange(htK.Values);
        arrK.Sort(PozycjaDokHandlowegoProxy.LpComparer);

        arr.AddRange(ht.Values);
        arr.Sort(PozycjaDokHandlowegoProxy.LpComparer);

        arrK.AddRange(arr);
        return arrK;
    }

    private bool SprawdźPłatności( DokumentHandlowy dokument ) {
        bool result = false;
        foreach( Platnosc platnosc in dokument.Platnosci ) {
            if( platnosc.Kwota.Symbol.Equals( "PLN" ) ) {
                result = true;
            }
        }
        return result;
    }

    private bool SprawdźSwift( DokumentHandlowy dokument ) {
        bool warunek1 = dokument.DaneKontrahenta == null || dokument.RachunekBankowy == null || dokument.RachunekBankowy.Rachunek == null || dokument.RachunekBankowy.Rachunek.SWIFT == "";
        bool warunek2 = false;
        if( dokument.Kontrahent != null && dokument.Kontrahent.RodzajPodmiotu == RodzajPodmiotu.Krajowy ) 
            warunek2 = dokument.RachunekBankowy != null && dokument.RachunekBankowy.Waluta.Symbol.Equals( "PLN" ) && SprawdźPłatności( dokument );   

        return ( warunek1 || warunek2 );
    }

    private bool SprawdźSwift2( DokumentHandlowy dokument ) {
        bool warunek1 = dokument.DaneKontrahenta == null || dokument.RachunekBankowy2 == null || dokument.RachunekBankowy2.Rachunek == null || dokument.RachunekBankowy2.Rachunek.SWIFT == "";
        bool warunek2 = false;
        if( !warunek1 && dokument.Kontrahent != null && dokument.Kontrahent.RodzajPodmiotu == RodzajPodmiotu.Krajowy ) 
            warunek2 = dokument.RachunekBankowy2 != null && dokument.RachunekBankowy2.Waluta.Symbol.Equals( "PLN" ) && SprawdźPłatności( dokument );   

        return ( warunek1 && warunek2 );
    }     	  
    
    private static bool NIPOdbiorcyPusty(DokumentHandlowy dokument)
    {
        if (dokument.Odbiorca == null) return false;
        return string.IsNullOrWhiteSpace(dokument.Odbiorca.NIP) && string.IsNullOrWhiteSpace(dokument.DaneOdbiorcy.EuVAT);
    }

    void OnContextLoad(Object sender, EventArgs args) {
        DataRepeater1.DataSource = (IEnumerable)Parametry;
        DokumentHandlowy dokument = Parametry.Dokument;

        NipSection.Visible = dokument.DaneKontrahenta.StatusPodmiotu != StatusPodmiotu.Finalny || !String.IsNullOrEmpty( dokument.DaneKontrahenta.EuVAT );

        IPieczątkaFirmy pieczątka = ReportHeader.GetPieczątka( dc, null, false);
        NazwaFirmy.EditValue = pieczątka.NazwaFormatowana;
        AdresLinia1.EditValue = pieczątka.Adres.Linia1;
        AdresLinia2.EditValue = pieczątka.Adres.Linia2;
        var BDO = pieczątka.BDO;
        BDOFirmyS.EditValue = "BDO: " + BDO;

         if(String.IsNullOrWhiteSpace(BDO))
            BDOFirmyS.Visible = false;
        
        if( dokument.Kontrahent.RodzajPodmiotu != RodzajPodmiotu.Krajowy )
            NipFirmy.EditValue = pieczątka.EuVAT.Replace("-", String.Empty);
        else
            NipFirmy.EditValue = pieczątka.NIP;
        

        

        ReportHeader.Title = dokument.Definicja.IsParagon ? "Paragon {0}" : "Faktura {0}";

        if (NIPOdbiorcyPusty(dokument))
            OdbiorcaNIP.Visible = false;

        if (dokument.RachunekBankowy == null
            || dokument.RachunekBankowy.Rachunek == null
            || dokument.RachunekBankowy.Rachunek.Bank == null)
            labelBank.Visible = false;

        if( !dokument.Definicja.DrukujSWIFTZawsze ) {
            if( SprawdźSwift( dokument ) )
                labelSwift.Visible = false;
        }

        if (dokument.RachunekBankowy2 == null
            || dokument.RachunekBankowy2.Rachunek == null
            || dokument.RachunekBankowy2.Rachunek.Bank == null)
            labelBank2.Visible = false;
        
        if( SprawdźSwift2( dokument ) )
            labelSwift2.Visible = false;

        //Tylko tyle zostało z kodu liczącego płatności.
        platnik.Visible = dokument.InnyPłatnik;

        sww.Visible = dokument.JestSWW;
        RodzajKorektyCol.Visible = dokument.DokumentKorygowany != null;

        //Ukrywamy tabelkę VAT i kolumny VAT dla dokumentów nie VAT
        //Dostosowujemy nazwy kolumn
        string nazwa;
        if (dokument.Definicja.SumyVAT != SposobLiczeniaSumVAT.NieLiczyć)
            nazwa = "faktury";
        else {
            SectionVAT.Visible = false;
            vat.Visible = false;
            nazwa = "rachunku";
        }

        //Jeżeli dokumenty liczone od brutto, to wymieniamy nagłówki
        if (dokument.OdBrutto)
            wartosc.Caption = "Wartość brutto";

        if (dokument.Wydruk.NabywcaPodatnik == 1)
            SectionVAT.Visible = false;
        
        // Ukrywanie ceny netto/brutto zależnie od typu dokumentu
        Grid1_CenaNettoPoRabacie.Visible = !dokument.OdBrutto;
        Grid1_CenaBruttoPoRabacie.Visible = dokument.OdBrutto;

        //Formatujemy podpisy
        stPodpis.Caption = "<font size=1>Dokument wystawił: </font><font size=2>"+dokument.Wydruk.UprawnionyDoWystawienia.FullName+"</font><br><br><font size=1>..................................................<br>Podpis osoby uprawnionej do wystawienia "+nazwa+"</font>";
        stOsoba.Caption = "<font size=2>" + dokument.Osoba + "</font><br><br><font size=1>..................................................<br>Podpis osoby upoważnionej do otrzymania " + nazwa + "</font>";
        Grid1.DataSource = this.PozycjeRazemWgTowaruICenyZKorektami(dokument);

        if (dokument.ID < 0 || dokument.State == RowState.Modified)
            DataLabelOstrzezenie.EditValue = "Zmiany na dokumencie nie zostały zatwierdzone";

        lDataEtykieta.Visible = lData.Visible = dokument.Wydruk.DatyDokumentu.IsVisibleData;
        lDataDostawyEtykieta.Visible = lDataDostawy.Visible = dokument.Wydruk.DatyDokumentu.IsVisibleDataDostawy;
        lDataOperacjiEtykieta.Visible = lDataOperacji.Visible = dokument.Wydruk.DatyDokumentu.IsVisibleDataOperacji;
        lDataOtrzymaniaEtykieta.Visible = lDataOtrzymania.Visible = dokument.Wydruk.DatyDokumentu.IsVisibleDataOtrzymania;

    ObcyKorygowany.Visible = dokument.DokumentyKorygowanePierwsze.Any(x => !string.IsNullOrEmpty(x.Obcy.Numer));
    }

    void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
        KopiaDokumentu kopia = (KopiaDokumentu)DataRepeater1.CurrentRow;
        DokumentHandlowy dokument = kopia.Dokument;
        if (kopia.Kopia == TypKopiiDokumentu.Duplikat || kopia.Kopia == TypKopiiDokumentu.OryginałDuplikat || kopia.Kopia == TypKopiiDokumentu.KopiaDuplikat)
            lDataDuplikatuEtykieta.Visible = lDataDuplikatu.Visible = true;
    }

    void niezapłacone_BeforeRow(Object sender, RowEventArgs args) {
        WydrukDokumentu.NiezapłaconeInfo p = (WydrukDokumentu.NiezapłaconeInfo)args.Row;

         // Mateusz - task 10271
        if( p.Płatność.SposobZaplaty.Typ != TypySposobowZaplaty.Przelew 
            || ( p.Płatność.SposobZaplaty.Typ == TypySposobowZaplaty.Przelew && p.Płatność.EwidencjaSP.Rachunek.Numer == (p.Płatność.Dokument as DokumentHandlowy).RachunekBankowy.Rachunek.Numer 
            && (p.Płatność.Dokument as DokumentHandlowy).Wydruk.Niezapłacone.Count == 1 ) ) { // dla całej reszty zostawiamy jak leci
            SposobZaplaty.EditValue = p.Płatność.SposobZaplaty;
        }
        else  { // a dla przelewu doklejamy numer rachunku
            SposobZaplaty.AddLine( p.Płatność.SposobZaplaty + " na rachunek bankowy" );
            SposobZaplaty.AddLine( p.Płatność.EwidencjaSP.Rachunek.Numer );
        }

        if ((p.Płatność.Dokument as DokumentHandlowy).InnyPłatnik) {
            platnik.AddLine(p.Płatność.Podmiot.Nazwa);
            platnik.AddLine(p.Płatność.Podmiot.Adres);
            platnik.AddLine("NIP: " + p.Płatność.Podmiot.EuVAT);
        }
    }
    void gridZaliczki_BeforeRow(object sender, RowEventArgs args)
    {
        DokumentHandlowy z = (DokumentHandlowy)args.Row;
        DokumentHandlowy d = (DokumentHandlowy)this.dc.Context[typeof(DokumentHandlowy)];
        SubTable st = d.ZaliczkiRelacje;
        if (st.IsEmpty
            && z.SposobPrzenoszeniaZaliczki == SposobPrzenoszeniaZaliczki.NieDotyczy)
        {
            this.colZaliczka.EditValue = z.BruttoCy;
        }
        else
        {
            Currency v = new Currency(decimal.Zero, z.BruttoCy.Symbol);
            foreach (RelacjaHandlowa.Zaliczka rz in st)
            {
                if (rz.Nadrzedny == z)
                {
                    v += rz.Wartosc;
                }
            }
            this.colZaliczka.EditValue = v;
        }
    }	
</script>

<body>
    <form id="Sprzedaż" method="post" runat="server">
    <ea:DataContext ID="dc" runat="server" TypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
        OnContextLoad="OnContextLoad" RightMargin="-1" LeftMargin="-1"></ea:DataContext>
    <ea:DataRepeater ID="DataRepeater1" runat="server" OnBeforeRow="DataRepeater1_BeforeRow"
        RowTypeName="Soneta.Handel.KopiaDokumentu,Soneta.Handel" Width="100%" Height="161px">
        <ea:SectionMarker ID="SectionMarker9" runat="server">
        </ea:SectionMarker>
        <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" ResetPageCounter="True" BreakDocument="True">
        </ea:PageBreak>
        <cc1:ReportHeader ID="ReportHeader" runat="server" DataMember0="Dokument.Numer" FirstHeader="False" />
        <div style="border-top: 1px solid; width: 100%; border-bottom: 1px solid">
            <table id="Table4" style="font-size: 10px; font-family: Tahoma" width="100%">
                <tr>
                    <td style="font-weight: bold; font-size: 18px;" valign="top" align="left">
                        <ea:DataLabel ID="DataLabel19" runat="server" DataMember="Dokument.Definicja.TytulWydruku">
                        </ea:DataLabel>
                        <ea:DataLabel ID="DataLabel20" runat="server" DataMember="Dokument.Session.Handel.Config.Ogólne.MałyPodatnik">
                            <ValuesMap>
                                <ea:ValuesPair Key="False" Value=""></ea:ValuesPair>
                                <ea:ValuesPair Key="True" Value=" MP"></ea:ValuesPair>
                            </ValuesMap>
                        </ea:DataLabel>
                        &nbsp;nr
                        <ea:DataLabel ID="DataLabel15" runat="server" DataMember="Dokument.Numer">
                        </ea:DataLabel>
                        <ea:DataLabel ID="DataLabel4" runat="server" DataMember="Dokument.Stan">
                            <ValuesMap>
                                <ea:ValuesPair Key="Anulowany" Value="&lt;br&gt;Dokument został anulowany"></ea:ValuesPair>
                                <ea:ValuesPair Key="Bufor" Value="&lt;br&gt;Dokument nie został zatwierdzony"></ea:ValuesPair>
                                <ea:ValuesPair Key="Zablokowany" Value=""></ea:ValuesPair>
                                <ea:ValuesPair Key="Zatwierdzony" Value=""></ea:ValuesPair>
                            </ValuesMap>
                        </ea:DataLabel>
                        <br>
                        <ea:DataLabel ID="DataLabelOstrzezenie" runat="server"></ea:DataLabel>
                        <br/>
                        <span style="font-weight: normal; font-size: 13px;">
                            <ea:DataLabel ID="DataLabel18" runat="server" DataMember="Kopia" Bold="False">
                            </ea:DataLabel>
                        </span>
                    </td>
                    <td valign="top" align="right">
                    </td>
                    <td width="10">
                            <ea:DataLabel ID="lDataEtykieta" runat="server" DataMember="Dokument.Wydruk.DatyDokumentu.DataEtykieta" Bold="False" EncodeHTML="True"></ea:DataLabel> 
                            <br/>
                            <ea:DataLabel ID="lDataDostawyEtykieta" runat="server" DataMember="Dokument.Wydruk.DatyDokumentu.DataDostawyEtykieta" Bold="False" EncodeHTML="True"></ea:DataLabel>
                            <br/>
                            <ea:DataLabel ID="lDataOperacjiEtykieta" runat="server" DataMember="Dokument.Wydruk.DatyDokumentu.DataOperacjiEtykieta" Bold="False" EncodeHTML="True"></ea:DataLabel>
                            <br/>
                            <ea:DataLabel ID="lDataOtrzymaniaEtykieta" runat="server" DataMember="Dokument.Wydruk.DatyDokumentu.DataOtrzymaniaEtykieta" Bold="False" EncodeHTML="True"></ea:DataLabel>
                            <br/>
                            <ea:DataLabel ID="lDataDuplikatuEtykieta" runat="server" DataMember="Dokument.Wydruk.DatyDokumentu.DataDuplikatuEtykieta" Bold="False" EncodeHTML="True" Visible="False"></ea:DataLabel>
                    </td>
                    <td valign="top" align="right">
                           <ea:DataLabel ID="lData" runat="server" DataMember="Dokument.Wydruk.DatyDokumentu.Data" EncodeHTML="True"> </ea:DataLabel>
                            <br/>
                            <ea:DataLabel ID="lDataDostawy" runat="server" DataMember="Dokument.Wydruk.DatyDokumentu.DataDostawy" EncodeHTML="True"> </ea:DataLabel>
                            <br/>
                            <ea:DataLabel ID="lDataOperacji" runat="server" DataMember="Dokument.Wydruk.DatyDokumentu.DataOperacji" EncodeHTML="True"> </ea:DataLabel>
                            <br/>
                            <ea:DataLabel ID="lDataOtrzymania" runat="server" DataMember="Dokument.Wydruk.DatyDokumentu.DataOtrzymania" EncodeHTML="True"> </ea:DataLabel>
                            <br/>
                            <ea:DataLabel ID="lDataDuplikatu" runat="server" DataMember="Dokument.Wydruk.DatyDokumentu.DataDuplikatu" EncodeHTML="True" Visible="False"> </ea:DataLabel>
                    </td>
                </tr>
            </table>
        </div>
        <table id="Table1" width="100%">
            <tr>
                <td valign="top" colspan="2">
                    <ea:Section ID="Section4" runat="server" Width="100%" DataMember="Dokument.DokumentKorygowany"
                        ConditionValue="IS NOT NULL">
                        <em><u>Dokument korygowany:</u></em>
                        <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                            <ea:datarepeater runat="server" rowtypename="Soneta.Handel.DokumentHandlowy,Soneta.Handel" DataMember="Dokument.DokumentyKorygowanePierwsze">
                                    <ea:DataLabel runat="server" DataMember="Numer" EncodeHTML="True"> </ea:DataLabel>

                                <ea:Section  ID="ObcyKorygowany" runat="server" EncodeHTML="True">
                                            <br />
                                            <span style="font-weight: normal; font-size: 13px;" >
                                                Dokument obcy nr:                                          
                                            <ea:DataLabel runat="server" DataMember="Obcy.Numer" EncodeHTML="True">
                                            </ea:DataLabel>
                                            </span>
                                        </ea:Section>

                                    <br/>
                                    <ea:DataLabel runat="server" DataMember="Wydruk.DatyDokumentu.DataEtykieta" Bold="False" EncodeHTML="True"> </ea:DataLabel>
                                    <ea:DataLabel runat="server" DataMember="Wydruk.DatyDokumentu.Data" EncodeHTML="True"> </ea:DataLabel>
                                    <br/>
                                    <ea:DataLabel runat="server" DataMember="Wydruk.DatyDokumentu.DataOperacjiEtykieta" Bold="False" EncodeHTML="True"> </ea:DataLabel>
                                    <ea:DataLabel runat="server" DataMember="Wydruk.DatyDokumentu.DataOperacji" EncodeHTML="True"> </ea:DataLabel>
                                    <br />
                            </ea:DataRepeater>
                        </div>
                    </ea:Section>
                </td>
            </tr>
            <tr>
                <td valign="top" width="50%">
                    <em><u>Sprzedawca:</u></em>
                    <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                        <ea:DataLabel ID="NazwaFirmy" runat="server"></ea:DataLabel>
                        <br>
                        <ea:DataLabel ID="AdresLinia1" runat="server" Bold="False"></ea:DataLabel>
                        <br>
                        <ea:DataLabel ID="AdresLinia2" runat="server" Bold="False"></ea:DataLabel>
                        <br>
                        NIP:
                        <ea:DataLabel ID="NipFirmy" runat="server" Bold="False"></ea:DataLabel>
                        <br>
                        <ea:DataLabel ID="BDOFirmyS" runat="server" Bold="False" EncodeHTML="True" />
                    </div>
                    <!-- Oddział firmy -->
                    <ea:Section ID="OddzialFirmy" runat="server" DataMember="Dokument.Wydruk.JestOddzial">
                        <em style="text-decoration: underline;">Oddział:</em>
                        <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative;">
                            <ea:DataLabel ID="DataLabel42" runat="server" EncodeHTML="True" DataMember="Dokument.Wydruk.PieczatkaOddziału.Nazwa"></ea:DataLabel> <br />
                            <ea:DataLabel ID="DataLabel44" runat="server" EncodeHTML="True" Bold="false" DataMember="Dokument.Wydruk.PieczatkaOddziału.Adres.Linia1"> </ea:DataLabel> <br />
                            <ea:DataLabel ID="DataLabel45" runat="server" EncodeHTML="True" Bold="false" DataMember="Dokument.Wydruk.PieczatkaOddziału.Adres.Linia2"> </ea:DataLabel>
                        </div>
                    </ea:Section>
                    <!-- Oddział firmy -->
                    <em><u>Konto bankowe:</u></em>
                    <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                        <ea:DataLabel ID="labelBank" runat="server" DataMember="Dokument.RachunekBankowy.Rachunek.Bank.Nazwa"
                            Bold="False" Format="{0}<br>">
                        </ea:DataLabel>
                        <ea:DataLabel ID="labelSwift" runat="server" DataMember="Dokument.RachunekBankowy.Rachunek.SWIFT"
                            Bold="False" Format="SWIFT: {0}<br>">
                        </ea:DataLabel>
                        <ea:DataLabel ID="DataLabel12" runat="server" DataMember="Dokument.RachunekBankowy.Rachunek.Numer"
                            Bold="False">
                        </ea:DataLabel>
                    </div>
                    <ea:Section ID="DrugiRachunekSection" runat="server" DataMember="Dokument.IsRachunekBankowy2">
                    <em><u>Drugie konto bankowe:</u></em>
                    <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                        <ea:DataLabel ID="labelBank2" runat="server" DataMember="Dokument.RachunekBankowy2.Rachunek.Bank.Nazwa"
                            Bold="False" Format="{0}<br>">
                        </ea:DataLabel>
                        <ea:DataLabel ID="labelSwift2" runat="server" DataMember="Dokument.RachunekBankowy2.Rachunek.SWIFT"
                            Bold="False" Format="SWIFT: {0}<br>">
                        </ea:DataLabel>
                        <ea:DataLabel ID="DataLabel47" runat="server" DataMember="Dokument.RachunekBankowy2.Rachunek.Numer"
                            Bold="False">
                        </ea:DataLabel>
                    </div>
                    </ea:Section>
                </td>
                <td valign="top">
                    <em><u>Nabywca:</u></em>
                    <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                        <ea:DataLabel ID="DataLabel1" runat="server" DataMember="Dokument.DaneKontrahenta.NazwaFormatowana">
                        </ea:DataLabel>
                        <br>
                        <ea:DataLabel ID="DataLabel2" runat="server" DataMember="Dokument.DaneKontrahenta.Adres.Linia1"
                            Bold="False">
                        </ea:DataLabel>
                        <br>
                        <ea:DataLabel ID="DataLabel3" runat="server" DataMember="Dokument.DaneKontrahenta.Adres.Linia2"
                            Bold="False">
                        </ea:DataLabel>
                        <br>
                        <ea:Section ID="NipSection" runat="server" >
                          NIP:
                          <ea:DataLabel ID="DataLabel11" runat="server" DataMember="Dokument.DaneKontrahenta.EuVAT"
                              Bold="False">
                          </ea:DataLabel>
                        </ea:Section>
                    </div>
                    <ea:Section ID="sectionOdbiorca" runat="server" DataMember="Dokument.Wydruk.JestOdbiorca">
                        <em><u>Odbiorca:</u></em>
                        <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                            <ea:DataLabel ID="DataLabel10" runat="server" DataMember="Dokument.DaneOdbiorcy.NazwaFormatowana">
                            </ea:DataLabel>
                            <br>
                            <ea:DataLabel ID="DataLabel9" runat="server" DataMember="Dokument.DaneOdbiorcy.Adres.Linia1"
                                Bold="False">
                            </ea:DataLabel>
                            <br>
                            <ea:DataLabel ID="DataLabel8" runat="server" DataMember="Dokument.DaneOdbiorcy.Adres.Linia2"
                                Bold="False">
                            </ea:DataLabel>
                            <br>
                            <ea:Section ID="OdbiorcaNIP" runat="server" >
                                NIP:
                                <ea:DataLabel ID="DataLabel7" runat="server" DataMember="Dokument.DaneOdbiorcy.EuVAT" Bold="False" EncodeHTML="True">
                                </ea:DataLabel>  
                            </ea:Section>
                        </div>
                    </ea:Section>
                </td>
            </tr>
        </table>
        <ea:Section ID="KursSection" runat="server" Width="100%" DataMember="Dokument.Wydruk.JestWaluta">
            <font size="2">Kurs <strong>1 </strong>
                <ea:DataLabel ID="DataLabel31" runat="server" DataMember="Dokument.BruttoCy.Symbol">
                </ea:DataLabel>
                &nbsp;=
                <ea:DataLabel ID="KursWaluty" runat="server" DataMember="Dokument.KursWaluty">
                </ea:DataLabel>
                <strong>&nbsp;PLN</strong> z dnia
                <ea:DataLabel ID="DataLabel32" runat="server" DataMember="Dokument.DataOgłoszeniaKursu">
                </ea:DataLabel>
                &nbsp;(<ea:DataLabel ID="DataLabel33" runat="server" DataMember="Dokument.TabelaKursowa">
                </ea:DataLabel>
                )</font></ea:Section>
        <ea:Grid ID="Grid1" runat="server" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel"
            RowsInRow="2" GroupData0="Workers.WydrukPozycji.SekcjaDokumentu" GroupLine="{0}">
            <Columns>
                <ea:GridColumn Width="4" Align="Right" DataMember="Lp" Caption="Lp." RowSpan="2"
                    runat="server">
                </ea:GridColumn>
                <ea:GridColumn DataMember="NazwaPierwszaLinia" Caption="Nazwa towaru/usługi" runat="server"
                    EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn DataMember="NazwaResztaLinii" Caption=" " runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="10" RightBorder="None" Align="Right" DataMember="Ilosc.Value"
                    Caption="Ilość" RowSpan="2" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="5" DataMember="Ilosc.Symbol" Caption="jm." RowSpan="2" runat="server">
                </ea:GridColumn>
                <ea:GridColumn ID="Grid1_CenaNettoPoRabacie" Width="15" Align="Right" DataMember="CenaNettoPoRabacie" Caption="Cena netto"
                    RowSpan="2" runat="server">
                </ea:GridColumn>
                <ea:GridColumn ID="Grid1_CenaBruttoPoRabacie" Width="15" Align="Right" DataMember="CenaBruttoPoRabacie" Caption="Cena brutto"
                    RowSpan="2" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="16" Align="Right" DataMember="WartoscCy" Caption="Wartość netto"
                    Format="&lt;b&gt;{0}&lt;/b&gt;" ID="wartosc" RowSpan="2" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="10" Align="Right" DataMember="DefinicjaStawki" Caption="Stawka VAT"
                    ID="vat" RowSpan="2" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="15" DataMember="SWW" Caption="PKWiU" ID="sww" RowSpan="2"
                    runat="server">
                </ea:GridColumn>
                <ea:GridColumn runat="server" ID="RodzajKorektyCol" DataMember="RodzajKorektyOpis" Width="16"
                    Caption="Zmiana" RowSpan="2" Align="Center">
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
        <ea:Section ID="SectionVAT" runat="server" Width="100%">
            <table cellpadding="0" cellspacing="0" border="0">
                <tr>
                    <td width="100%" style="font-size: 10px;">
                        <ea:DataLabel ID="DataLabel24" runat="server" DataMember="Dokument.Wydruk.InfoKorekty1"
                            Bold="False">
                        </ea:DataLabel>
                        <br />
                        <ea:DataLabel ID="DataLabel41" runat="server" DataMember="Dokument.Wydruk.InfoKorekty2"
                            Bold="False">
                        </ea:DataLabel>
                    </td>
                    <td align="right">
                        <ea:Grid ID="Grid5" runat="server" RowTypeName="Soneta.Handel.SumaVAT,Soneta.Handel"
                            DataMember="Dokument.SumyVAT" WithSections="False">
                            <Columns>
                                <ea:GridColumn ID="GridColumn1" Width="15" Align="Right" DataMember="DefinicjaStawki"
                                    Total="Info" Caption="Stawka VAT" runat="server">
                                </ea:GridColumn>
                                <ea:GridColumn ID="GridColumn2" Width="17" Align="Right" DataMember="Suma.NettoCy"
                                    Total="Sum" Caption="Netto" runat="server">
                                </ea:GridColumn>
                                <ea:GridColumn ID="GridColumn3" Width="17" Align="Right" DataMember="Suma.VATCy"
                                    Total="Sum" Caption="Kwota VAT" Format="{0:n}" runat="server">
                                </ea:GridColumn>
                                <ea:GridColumn ID="GridColumn4" Width="17" Align="Right" DataMember="Suma.BruttoCy"
                                    Total="Sum" Caption="Brutto" runat="server">
                                </ea:GridColumn>
                            </Columns>
                        </ea:Grid>
                    </td>
                </tr>
            </table>
        </ea:Section>
        <ea:Section ID="Section3" runat="server" DataMember="Dokument.Wydruk.JestSumaPozycji"
            Width="100%">
            <em>Suma&nbsp;brutto dokumentu:</em>
            <ea:DataLabel ID="DataLabel34" runat="server" DataMember="Dokument.SumaPozycji.Brutto">
            </ea:DataLabel>
            &nbsp;PLN<br>
        </ea:Section>
        <ea:Section ID="sectionZaliczki" runat="server" DataMember="Dokument.DokumentyZaliczkowe">
            <em>Faktury zaliczkowe:<br>
            </em>
            <ea:Grid ID="gridZaliczki" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
                DataMember="Dokument.Wydruk.DokumentyZaliczkowe" WithSections="False" OnBeforeRow="gridZaliczki_BeforeRow">
                <Columns>
                    <ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp.">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="30" DataMember="Numer">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="15" Align="Center" DataMember="Data" Total="Info">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="18" Align="Right" DataMember="BruttoCy" Total="Sum"
                        Caption="Wartość">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="18" Align="Right" Total="Sum" ID="colZaliczka"
                        Caption="Rozliczona zaliczka"></ea:GridColumn>
                </Columns>
            </ea:Grid>
            <br>
        </ea:Section>
        <table id="Table3" cellspacing="0" cellpadding="0" width="90%">
            <tr>
                <td style="width: 151px" align="right" width="151">
                </td>
                <td style="width: 145px; border-bottom: black 1px solid" valign="bottom" align="left"
                    width="145" colspan="1" rowspan="1">
                    <ea:DataLabel ID="doZaplaty" runat="server" DataMember="Dokument.Wydruk.KierunekZapłaty"
                        Bold="False" Format="{0}:">
                    </ea:DataLabel>
                </td>
                <td style="font-weight: bold; font-size: 18px; border-bottom: black 1px solid;
                    height: 22px" valign="bottom" align="right">
                    <ea:DataLabel ID="DataLabel5" runat="server" DataMember="Dokument.Wydruk.BruttoCyPlus" Bold="False">
                    </ea:DataLabel>
                </td>
            </tr>
            <tr>
                <td style="width: 151px" align="right">
                </td>
                <td style="width: 145px" align="left">
                    <font size="2"><em>Słownie:</em></font>
                </td>
                <td align="right">
                    <font size="2"><em>
                        <ea:DataLabel ID="DataLabel6" runat="server" DataMember="Dokument.BruttoCy" Bold="False"
                            Format="{0:+t}">
                        </ea:DataLabel>
                    </em></font>
                </td>
            </tr>
        </table>
        <ea:Section ID="sectionWplaty" runat="server" DataMember="Dokument.Zaliczki">
            <em>Rozliczone zaliczki:<br>
            </em>
            <ea:Grid ID="Grid2" runat="server" RowTypeName="Soneta.Handel.RelacjaZaliczki,Soneta.Handel"
                DataMember="Dokument.Zaliczki" WithSections="False">
                <Columns>
                    <ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp.">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="20" DataMember="Zaplata.SposobZaplaty" Caption="Spos&#243;b zapłaty">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="15" Align="Center" DataMember="Zaplata.DataDokumentu"
                        Caption="Data zapłaty">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="20" Align="Right" DataMember="Kwota">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Width="25" DataMember="Zaplata.NumerDokumentu" Caption="Numer">
                    </ea:GridColumn>
                </Columns>
            </ea:Grid>
        </ea:Section>
        <br />
            <ea:Section ID="Section1" runat="server">
                <em>                
                    <ea:DataLabel ID="DataLabel13" runat="server" DataMember="Dokument.Wydruk.ZaplaconoInfo"
                        Bold="False">
                    </ea:DataLabel>                    
                    </em>
            </ea:Section>
        <br />
        <ea:Section ID="sectionNiezaplacone" runat="server" DataMember="Dokument.Wydruk.SąNiezapłacone">
            <div>
                <em>Pozostało do zapłaty:</em>
                <ea:Grid ID="niezapłacone" runat="server" OnBeforeRow="niezapłacone_BeforeRow" RowTypeName="Soneta.Kasa.Platnosc,Soneta.Kasa"
                    DataMember="Dokument.Wydruk.Niezapłacone" WithSections="False">
                    <Columns>
                        <ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp.">
                        </ea:GridColumn>
                        <ea:GridColumn runat="server" Width="40" ID="SposobZaplaty" Caption="Spos&#243;b zapłaty">
                        </ea:GridColumn>
                        <ea:GridColumn runat="server" Width="15" Align="Center" DataMember="Płatność.Termin"
                            Caption="Termin">
                        </ea:GridColumn>
                        <ea:GridColumn runat="server" Width="20" Align="Right" DataMember="Kwota">
                        </ea:GridColumn>
                        <ea:GridColumn runat="server" Caption="Płatnik" Format="{0:H}" ID="platnik">
                        </ea:GridColumn>
                    </Columns>
                </ea:Grid>
            </div>
        </ea:Section>
        <ea:Section ID="sectionNumeryNadrzednych" runat="server" DataMember="Dokument.Wydruk.CzyDrukowacNumeryPowiazanych">
            <em>Dokumenty powiązane:</em>
            <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
                <ea:DataLabel ID="labelNumeryNadrzednych" runat="server" DataMember="Dokument.Wydruk.NumeryNadrzędneZK" Bold="False"></ea:DataLabel>
                <ea:DataLabel ID="labelNumeryPodrzednych" runat="server" DataMember="Dokument.Wydruk.NumeryPodrzędneBK" Bold="False"></ea:DataLabel>
            </div>
        </ea:Section>
            <p style="font-family: Tahoma, Arial; font-size: 13px;">
                <ea:DataLabel ID="OpisDok" runat="server" DataMember="Dokument.Opis" Bold="False"> </ea:DataLabel>
            </p>
            <p style="font-family: Tahoma, Arial; font-size: 13px;">
                <ea:DataLabel ID="OpisWydruku" runat="server" DataMember="Dokument.Wydruk.OpisWydruku" Bold="False"> </ea:DataLabel>
            </p>
        <cc1:ReportFooter ID="ReportFooter1" runat="server" Height="105px" TheEnd="False">
            <Subtitles>
                <cc1:FooterSubtitle runat="server" Caption="Operator" ID="stPodpis" SubtitleType="CenterText"
                    Width="50">
                </cc1:FooterSubtitle>
                <cc1:FooterSubtitle runat="server" Caption="Osoba" ID="stOsoba" SubtitleType="CenterText"
                    Width="50">
                </cc1:FooterSubtitle>
            </Subtitles>
        </cc1:ReportFooter>
        <ea:SectionMarker ID="SectionMarker8" runat="server" SectionType="Footer">
        </ea:SectionMarker>
    </ea:DataRepeater>
    </form>
</body>
</html>
